#include <QurioFireMotor.h>            //Include VehicleMotor library
#include <QurioFireSensor.h>                  //Include Sensor library

QurioFireMotor motor;                   //Define variable motor of type VehicleMotor
QurioFireSensor IRsensorl;                     //Define variable IRSensorl for left IR sensor of type Sensor
QurioFireSensor IRsensorr;                     //Define variable IRSensorr for right IR sensor of type Sensor

#define IRpinl A0                      // Left IR sensor connected to digital pin A0
#define IRpinr A1                      // Right IR sensor connected to digital pin A1

void setup() {
  // put your setup code here, to run once:

}

void loop() {
  // put your main code here, to run repeatedly:
  // Use 2IR sensors to detect black line and decide the direction of turning. Connect left IR sensor to digital pin A0 and right IR sensor to digital pin A1

  if ((IRsensorl.getSensorValue(IRpinl)==0 && IRsensorr.getSensorValue(IRpinr)==0))         //vehicle on black line moves forward
  {
    motor.forward(255,255);
  }
  else if ((IRsensorl.getSensorValue(IRpinl)==0 && IRsensorr.getSensorValue(IRpinr)==1))    //turn vehicle to left when right sensor detects white color
  {
    motor.hardLeftTurn(255,255);
  }
  else if((IRsensorl.getSensorValue(IRpinl)==1) && (IRsensorr.getSensorValue(IRpinr)==0))   //turn vehicle to right when left sensor detects white color
  {
    motor.hardRightTurn(255,255);
  }
  else 
  {
    motor.vehStop();                                                               
  } 
  
}
